/*
  Simple analog input organ
 */

int analogInputPin;
int inputValue;
int speakerPin;


void setup() {    
  analogInputPin=0;
  speakerPin=7;
  // Analog pins are always an input so we don't need to assign those
  // Still assign the speaker as an output.
  pinMode(speakerPin, OUTPUT);
}

void loop() {
  // Find out the value of the analog input
  // analogRead returns a value of between 0 and 1023
  // where 0 is 0V and 1023 is 5V.
  inputValue=analogRead(analogInputPin);
  
  // Only want to play a note if the wire probes are on the track, so check
  // for voltages that aren't close to 0V before playing a tone
  // else silence the tone
  if (inputValue>10) {
    // Want the frequency to go up as the voltage at the pin goes down, so
    // reduce the starting frequency depending on the voltage
    tone(speakerPin,2000-2*inputValue);
  }
  else {
    noTone(speakerPin);
  }
    
}
