/* B-em v2.2 by Tom Walker
 * Pico version (C) 2021 Graham Sanderson
 */
#ifndef B_EM_PICO_DISPLAY_TABLES_H
#define B_EM_PICO_DISPLAY_TABLES_H

#include "display.h"

// bits 7531 -> 3210
static __scratch_y("display") uint8_t aa2f[256] = {
        0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x2, 0x2, 0x3, 0x3,
        0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x2, 0x2, 0x3, 0x3,
        0x4, 0x4, 0x5, 0x5, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x7, 0x6, 0x6, 0x7, 0x7,
        0x4, 0x4, 0x5, 0x5, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x7, 0x6, 0x6, 0x7, 0x7,
        0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x2, 0x2, 0x3, 0x3,
        0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x2, 0x2, 0x3, 0x3,
        0x4, 0x4, 0x5, 0x5, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x7, 0x6, 0x6, 0x7, 0x7,
        0x4, 0x4, 0x5, 0x5, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x7, 0x6, 0x6, 0x7, 0x7,
        0x8, 0x8, 0x9, 0x9, 0x8, 0x8, 0x9, 0x9, 0xa, 0xa, 0xb, 0xb, 0xa, 0xa, 0xb, 0xb,
        0x8, 0x8, 0x9, 0x9, 0x8, 0x8, 0x9, 0x9, 0xa, 0xa, 0xb, 0xb, 0xa, 0xa, 0xb, 0xb,
        0xc, 0xc, 0xd, 0xd, 0xc, 0xc, 0xd, 0xd, 0xe, 0xe, 0xf, 0xf, 0xe, 0xe, 0xf, 0xf,
        0xc, 0xc, 0xd, 0xd, 0xc, 0xc, 0xd, 0xd, 0xe, 0xe, 0xf, 0xf, 0xe, 0xe, 0xf, 0xf,
        0x8, 0x8, 0x9, 0x9, 0x8, 0x8, 0x9, 0x9, 0xa, 0xa, 0xb, 0xb, 0xa, 0xa, 0xb, 0xb,
        0x8, 0x8, 0x9, 0x9, 0x8, 0x8, 0x9, 0x9, 0xa, 0xa, 0xb, 0xb, 0xa, 0xa, 0xb, 0xb,
        0xc, 0xc, 0xd, 0xd, 0xc, 0xc, 0xd, 0xd, 0xe, 0xe, 0xf, 0xf, 0xe, 0xe, 0xf, 0xf,
        0xc, 0xc, 0xd, 0xd, 0xc, 0xc, 0xd, 0xd, 0xe, 0xe, 0xf, 0xf, 0xe, 0xe, 0xf, 0xf,
};

// 128 entries per byte layout (1, 2, 4, 8, 16 pixels per byte)
// each 128 byte entry is made of 16 bit vectors (1 per ULA palette index color). Each bit vector
// is 8 words, i.e. 256 bits = 1 bit per possible byte value indicating if a change to the given
// palette index affects the pixels displayed for that byte value

#ifdef NEED_SPACE
#error // todo remove 1 and or 16 to save space - 1 is particularly useless
#endif
static uint32_t palette_touch[5 * 128] = {
        0x00330033, 0x00000000, 0x00330033, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 0
        0x00cc00cc, 0x00000000, 0x00cc00cc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 1
        0x33003300, 0x00000000, 0x33003300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 2
        0xcc00cc00, 0x00000000, 0xcc00cc00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 3
        0x00000000, 0x00330033, 0x00000000, 0x00330033, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 4
        0x00000000, 0x00cc00cc, 0x00000000, 0x00cc00cc, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 5
        0x00000000, 0x33003300, 0x00000000, 0x33003300, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 6
        0x00000000, 0xcc00cc00, 0x00000000, 0xcc00cc00, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 7
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00330033, 0x00000000, 0x00330033, 0x00000000,  // 8
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00cc00cc, 0x00000000, 0x00cc00cc, 0x00000000,  // 9
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33003300, 0x00000000, 0x33003300, 0x00000000,  // a
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xcc00cc00, 0x00000000, 0xcc00cc00, 0x00000000,  // b
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00330033, 0x00000000, 0x00330033,  // c
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00cc00cc, 0x00000000, 0x00cc00cc,  // d
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33003300, 0x00000000, 0x33003300,  // e
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xcc00cc00, 0x00000000, 0xcc00cc00,  // f

        0x00330537, 0x00000505, 0x00330033, 0x00000000, 0x00000505, 0x00000505, 0x00000000, 0x00000000,  // 0
        0x00cc0ace, 0x00000a0a, 0x00cc00cc, 0x00000000, 0x00000a0a, 0x00000a0a, 0x00000000, 0x00000000,  // 1
        0x33007350, 0x00005050, 0x33003300, 0x00000000, 0x00005050, 0x00005050, 0x00000000, 0x00000000,  // 2
        0xcc00eca0, 0x0000a0a0, 0xcc00cc00, 0x00000000, 0x0000a0a0, 0x0000a0a0, 0x00000000, 0x00000000,  // 3
        0x05050000, 0x05370033, 0x00000000, 0x00330033, 0x05050000, 0x05050000, 0x00000000, 0x00000000,  // 4
        0x0a0a0000, 0x0ace00cc, 0x00000000, 0x00cc00cc, 0x0a0a0000, 0x0a0a0000, 0x00000000, 0x00000000,  // 5
        0x50500000, 0x73503300, 0x00000000, 0x33003300, 0x50500000, 0x50500000, 0x00000000, 0x00000000,  // 6
        0xa0a00000, 0xeca0cc00, 0x00000000, 0xcc00cc00, 0xa0a00000, 0xa0a00000, 0x00000000, 0x00000000,  // 7
        0x00000000, 0x00000000, 0x00000505, 0x00000505, 0x00330033, 0x00000000, 0x00330537, 0x00000505,  // 8
        0x00000000, 0x00000000, 0x00000a0a, 0x00000a0a, 0x00cc00cc, 0x00000000, 0x00cc0ace, 0x00000a0a,  // 9
        0x00000000, 0x00000000, 0x00005050, 0x00005050, 0x33003300, 0x00000000, 0x33007350, 0x00005050,  // a
        0x00000000, 0x00000000, 0x0000a0a0, 0x0000a0a0, 0xcc00cc00, 0x00000000, 0xcc00eca0, 0x0000a0a0,  // b
        0x00000000, 0x00000000, 0x05050000, 0x05050000, 0x00000000, 0x00330033, 0x05050000, 0x05370033,  // c
        0x00000000, 0x00000000, 0x0a0a0000, 0x0a0a0000, 0x00000000, 0x00cc00cc, 0x0a0a0000, 0x0ace00cc,  // d
        0x00000000, 0x00000000, 0x50500000, 0x50500000, 0x00000000, 0x33003300, 0x50500000, 0x73503300,  // e
        0x00000000, 0x00000000, 0xa0a00000, 0xa0a00000, 0x00000000, 0xcc00cc00, 0xa0a00000, 0xeca0cc00,  // f

        0x00330537, 0x00000505, 0x00330033, 0x00000000, 0x00000505, 0x00000505, 0x00000000, 0x00000000,  // 0
        0x00ff0fff, 0x00000f0f, 0x00ff05ff, 0x00000505, 0x00330f3f, 0x00000f0f, 0x00330537, 0x00000505,  // 1
        0x33007350, 0x00005050, 0x33003300, 0x00000000, 0x00005050, 0x00005050, 0x00000000, 0x00000000,  // 2
        0xcccceeee, 0x0000aaaa, 0xcccccece, 0x00000a0a, 0x00ccaaee, 0x0000aaaa, 0x00cc0ace, 0x00000a0a,  // 3
        0x05050000, 0x05370033, 0x00000000, 0x00330033, 0x05050000, 0x05050000, 0x00000000, 0x00000000,  // 4
        0x3b0a7350, 0x0ace50dc, 0x33007350, 0x00cc50dc, 0x3b0a7350, 0x0a0a5050, 0x33007350, 0x00005050,  // 5
        0x50500000, 0x73503300, 0x00000000, 0x33003300, 0x50500000, 0x50500000, 0x00000000, 0x00000000,  // 6
        0xeca0eca0, 0xeca0eca0, 0xcc00eca0, 0xcc00eca0, 0xeca0eca0, 0xa0a0a0a0, 0xcc00eca0, 0x0000a0a0,  // 7
        0x00000000, 0x00000000, 0x00000505, 0x00000505, 0x00330033, 0x00000000, 0x00330537, 0x00000505,  // 8
        0x05050000, 0x05370033, 0x05050a0a, 0x05370a3b, 0x05cd00cc, 0x05370033, 0x05cd0ace, 0x05370a3b,  // 9
        0x00000000, 0x00000000, 0x00005050, 0x00005050, 0x33003300, 0x00000000, 0x33007350, 0x00005050,  // a
        0x0a0a0000, 0x0ace00cc, 0x0a0aa0a0, 0x0acea0ec, 0xce0acc00, 0x0ace00cc, 0xce0aeca0, 0x0acea0ec,  // b
        0x00000000, 0x00000000, 0x05050000, 0x05050000, 0x00000000, 0x00330033, 0x05050000, 0x05370033,  // c
        0x50500000, 0x73503300, 0x5a5a0000, 0x7b5a3300, 0x50500000, 0x73dc33cc, 0x5a5a0000, 0x7bde33cc,  // d
        0x00000000, 0x00000000, 0x50500000, 0x50500000, 0x00000000, 0x33003300, 0x50500000, 0x73503300,  // e
        0xa0a00000, 0xeca0cc00, 0xa0a00000, 0xeca0cc00, 0xa0a00000, 0xeca0cc00, 0xa0a00000, 0xeca0cc00,  // f

        0x00330537, 0x00000505, 0x00330033, 0x00000000, 0x00000505, 0x00000505, 0x00000000, 0x00000000,  // 0
        0x00ff0fff, 0x00000f0f, 0x00ff05ff, 0x00000505, 0x00330f3f, 0x00000f0f, 0x00330537, 0x00000505,  // 1
        0x33007350, 0x00005050, 0x33003300, 0x00000000, 0x00005050, 0x00005050, 0x00000000, 0x00000000,  // 2
        0xcdffefff, 0x0537afbf, 0xcdffcfff, 0x05370f3f, 0x05ffafff, 0x0537afbf, 0x05ff0fff, 0x05370f3f,  // 3
        0x05050000, 0x05370033, 0x00000000, 0x00330033, 0x05050000, 0x05050000, 0x00000000, 0x00000000,  // 4
        0x3b0a7350, 0x0ace50dc, 0x33007350, 0x00cc50dc, 0x3b0a7350, 0x0a0a5050, 0x33007350, 0x00005050,  // 5
        0x50500000, 0x73503300, 0x00000000, 0x33003300, 0x50500000, 0x50500000, 0x00000000, 0x00000000,  // 6
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x7fffffff,  // 7
        0x00000000, 0x00000000, 0x00000505, 0x00000505, 0x00330033, 0x00000000, 0x00330537, 0x00000505,  // 8
        0x05050000, 0x05370033, 0x05050a0a, 0x05370a3b, 0x05cd00cc, 0x05370033, 0x05cd0ace, 0x05370a3b,  // 9
        0x00000000, 0x00000000, 0x00005050, 0x00005050, 0x33003300, 0x00000000, 0x33007350, 0x00005050,  // a
        0x7b5a7350, 0x7bde73dc, 0x7b5af3f0, 0x7bdef3fc, 0xff5aff50, 0x7bde73dc, 0xff5afff0, 0x7bdef3fc,  // b
        0x00000000, 0x00000000, 0x05050000, 0x05050000, 0x00000000, 0x00330033, 0x05050000, 0x05370033,  // c
        0x50500000, 0x73503300, 0x5a5a0000, 0x7b5a3300, 0x50500000, 0x73dc33cc, 0x5a5a0000, 0x7bde33cc,  // d
        0x00000000, 0x00000000, 0x50500000, 0x50500000, 0x00000000, 0x33003300, 0x50500000, 0x73503300,  // e
        0xeeeeeeee, 0xeeeeeeee, 0xeeeeeeee, 0xeeeeeeee, 0xeeeeeeee, 0xeeeeeeee, 0xeeeeeeee, 0xeeeeeeee,  // f

        0x00330033, 0x00000000, 0x00330033, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 0
        0x00ff00ff, 0x00000000, 0x00ff00ff, 0x00000000, 0x00330033, 0x00000000, 0x00330033, 0x00000000,  // 1
        0x33003300, 0x00000000, 0x33003300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 2
        0xccffccff, 0x00330033, 0xccffccff, 0x00330033, 0x00ff00ff, 0x00330033, 0x00ff00ff, 0x00330033,  // 3
        0x00000000, 0x00330033, 0x00000000, 0x00330033, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 4
        0x33003300, 0x00cc00cc, 0x33003300, 0x00cc00cc, 0x33003300, 0x00000000, 0x33003300, 0x00000000,  // 5
        0x00000000, 0x33003300, 0x00000000, 0x33003300, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 6
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x33ff33ff, 0xffffffff, 0x33ff33ff,  // 7
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00330033, 0x00000000, 0x00330033, 0x00000000,  // 8
        0x00000000, 0x00330033, 0x00000000, 0x00330033, 0x00cc00cc, 0x00330033, 0x00cc00cc, 0x00330033,  // 9
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33003300, 0x00000000, 0x33003300, 0x00000000,  // a
        0x33003300, 0x33cc33cc, 0x33003300, 0x33cc33cc, 0xff00ff00, 0x33cc33cc, 0xff00ff00, 0x33cc33cc,  // b
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00330033, 0x00000000, 0x00330033,  // c
        0x00000000, 0x33003300, 0x00000000, 0x33003300, 0x00000000, 0x33cc33cc, 0x00000000, 0x33cc33cc,  // d
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33003300, 0x00000000, 0x33003300,  // e
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f
};

struct aligned_8_pixels {
    uint16_t p[8];
} __aligned(4);

struct maybe_aligned_8_pixels {
    uint16_t p[8];
};

static struct aligned_8_pixels tile8[256];
static uint16_t mode7_pixels[8][8][169];

static const uint8_t grey_pixels[169] = {
        0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf, 0xf, 0xa, 0x0, 0x0, 0x0, 0x0,
        0x0, 0xf, 0xf, 0xf, 0xf, 0xf, 0xa, 0x0, 0x0, 0x5, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
        0xf, 0xf, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf, 0xf, 0xf, 0x0, 0x5, 0xf, 0xf, 0xa, 0x0,
        0x0, 0x5, 0xf, 0xf, 0xf, 0xf, 0xf, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf,
        0x5, 0x0, 0x0, 0xa, 0xf, 0xf, 0x5, 0x0, 0x0, 0x0, 0xa, 0xf, 0xf, 0x5, 0x5, 0xf,
        0xf, 0xa, 0x0, 0xa, 0xf, 0xf, 0x5, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf, 0xf, 0x5, 0x0,
        0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x0, 0x0, 0x0, 0xf,
        0x5, 0x5, 0xf, 0xf, 0xa, 0x0, 0x0, 0x5, 0xf, 0xf, 0xa, 0x0, 0xa, 0xf, 0xf, 0xf,
        0xf, 0x5, 0x5, 0xf, 0xf, 0x5, 0x0, 0x0, 0x0, 0x5, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
        0xf, 0x5, 0xf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
        0xf, 0x0, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
};
// aligned 4 because we point at the first 16 bytes as 8 zero pixels
static __scratch_y("display") __aligned(4) uint8_t mode7_chars[1920] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x11, 0x04, 0x03, 0x04, 0x00, 0x18, 0x09, 0x04, 0x00, 0x04, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x2a, 0x14, 0x2a, 0x09, 0x22, 0x11, 0x01, 0x14, 0x2a, 0x14, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x30, 0x00, 0x30, 0x03, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x07, 0x2f, 0x00, 0x2f, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x2a, 0x09, 0x2a, 0x09, 0x04, 0x00, 0x2a, 0x14, 0x07, 0x06, 0x22, 0x14, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x01, 0x09, 0x00, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x01, 0x09, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x2a, 0x14, 0x22, 0x11, 0x01, 0x09, 0x22, 0x11, 0x2a, 0x14, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x18, 0x1a, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x04, 0x06, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x22, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x00, 0x03, 0x01, 0x11, 0x04, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x00, 0x03, 0x00, 0x06, 0x01, 0x11, 0x00, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x06, 0x01, 0x11, 0x04, 0x06, 0x07, 0x06, 0x18, 0x1a, 0x00, 0x06, 0x00, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x07, 0x00, 0x18, 0x11, 0x00, 0x03, 0x00, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x11, 0x04, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x03, 0x00, 0x06, 0x22, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x07, 0x00, 0x04, 0x00, 0x01, 0x09, 0x00, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1a, 0x00, 0x00, 0x18, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x01, 0x09, 0x00, 0x06, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x00, 0x06, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x2a, 0x1a, 0x2a, 0x14, 0x2a, 0x1a, 0x07, 0x00, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x04, 0x06, 0x07, 0x03, 0x07, 0x03, 0x18, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x07, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x07, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x07, 0x00, 0x07, 0x2f, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x18, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x06, 0x2a, 0x09, 0x30, 0x00, 0x2a, 0x09, 0x07, 0x06, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x30, 0x2f, 0x2a, 0x14, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x30, 0x03, 0x2a, 0x14, 0x07, 0x2f, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x07, 0x06, 0x22, 0x14, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x2a, 0x09, 0x07, 0x06, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x22, 0x11, 0x00, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x04, 0x06, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x04, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x01, 0x09, 0x04, 0x06, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x04, 0x00, 0x18, 0x1a, 0x04, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x2a, 0x11, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x01, 0x1a,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x06, 0x18, 0x1a, 0x00, 0x06, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x22, 0x11, 0x2a, 0x14, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x18, 0x1a, 0x04, 0x06, 0x18, 0x1a, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x00, 0x03, 0x22, 0x1a, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x1a, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x22, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x18, 0x1a, 0x07, 0x00, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x06, 0x01, 0x09, 0x01, 0x09, 0x22, 0x11, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x03,
        0x22, 0x11,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x22, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x04, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x03, 0x04, 0x06, 0x22, 0x09, 0x04, 0x06, 0x04, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x06, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x07, 0x00,
        0x07, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x03,
        0x00, 0x03,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x2f, 0x22, 0x09, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x1a, 0x07, 0x00, 0x22, 0x11, 0x00, 0x03, 0x18, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x22, 0x11, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x04, 0x06, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x04, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x04, 0x06, 0x01, 0x09, 0x04, 0x06, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x03,
        0x22, 0x11,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1a, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x03, 0x00, 0x2f, 0x01, 0x14, 0x01, 0x1a, 0x00, 0x03,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x30, 0x00, 0x01, 0x09, 0x30, 0x00, 0x01, 0x09, 0x30, 0x03, 0x00, 0x2f, 0x01, 0x14, 0x01, 0x1a,
        0x00, 0x03,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x18, 0x1a, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
};
static __scratch_y("display") uint8_t mode7_charsi[1920] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x3f, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x47, 0x4f, 0x2a, 0x09, 0x47, 0x09, 0x01, 0x4f, 0x01, 0x14, 0x47, 0x4f, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x30, 0x00, 0x00, 0x57, 0x00, 0x52, 0x38, 0x5d, 0x58, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x62, 0x5d, 0x2a, 0x09, 0x62, 0x5d, 0x62, 0x5d, 0x07, 0x64, 0x58, 0x64, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x52, 0x38, 0x5d, 0x04, 0x00, 0x04, 0x00, 0x38, 0x5d, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x5d, 0x00, 0x52, 0x00, 0x06, 0x00, 0x06, 0x00, 0x52, 0x38, 0x5d, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x47, 0x4f, 0x01, 0x09, 0x01, 0x09, 0x47, 0x4f, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x38, 0x5d, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x52, 0x38, 0x5d, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x67, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x38, 0x67, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x00, 0x03, 0x00, 0x57, 0x38, 0x5d, 0x58, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x57, 0x00, 0x06, 0x00, 0x57, 0x00, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x06, 0x38, 0x6f, 0x58, 0x06, 0x07, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x57, 0x00, 0x03, 0x00, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x5d, 0x58, 0x00, 0x07, 0x00, 0x07, 0x57, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x57, 0x00, 0x52, 0x38, 0x5d, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x58, 0x57, 0x58, 0x57, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x58, 0x03, 0x00, 0x03, 0x00, 0x57, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x38, 0x5d, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x52, 0x38, 0x5d, 0x58, 0x00, 0x58, 0x00, 0x38, 0x5d, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x5d, 0x00, 0x52, 0x00, 0x57, 0x00, 0x57, 0x00, 0x52, 0x38, 0x5d, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x00, 0x57, 0x00, 0x52, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x07, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x67, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x03, 0x58, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x52, 0x76, 0x5d, 0x76, 0x5d, 0x07, 0x52, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x76, 0x7d, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x76, 0x84, 0x07, 0x49, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x64, 0x58, 0x64, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x2a, 0x09, 0x07, 0x52, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x58, 0x00, 0x00, 0x57, 0x00, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x04, 0x06, 0x38, 0x67, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x62, 0x8a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x58, 0x57, 0x38, 0x67, 0x38, 0x67, 0x58, 0x57, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x58, 0x57, 0x38, 0x67, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x57, 0x00, 0x52, 0x38, 0x5d, 0x58, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x38, 0x5d, 0x04, 0x00, 0x04, 0x00, 0x38, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x57, 0x00, 0x57, 0x00, 0x52, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x06, 0x00, 0x06, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x47, 0x4f, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x03, 0x58, 0x03, 0x58, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x00, 0x07, 0x00, 0x07, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x58, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x07, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x52, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x03, 0x00, 0x03, 0x00, 0x57,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x38, 0x5d, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x57, 0x04, 0x52, 0x04, 0x52, 0x04, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x8a, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x57, 0x07, 0x00, 0x07, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x03, 0x00, 0x03, 0x00, 0x03,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x52, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x00, 0x58, 0x00, 0x00, 0x57, 0x00, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x58, 0x57, 0x04, 0x06, 0x38, 0x67, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x62, 0x8a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x57, 0x38, 0x67, 0x38, 0x67, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x03, 0x00, 0x03, 0x00, 0x57,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x52, 0x38, 0x5d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x03, 0x00, 0x49, 0x01, 0x14, 0x00, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x5d, 0x38, 0x5d, 0x38, 0x5d, 0x38, 0x5d, 0x00, 0x03, 0x00, 0x49, 0x01, 0x14, 0x00, 0x03,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x18, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
};
static const uint8_t mode7_graph[1920] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x2a, 0x1a, 0x2a, 0x14, 0x2a, 0x1a, 0x07, 0x00, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x04, 0x06, 0x07, 0x03, 0x07, 0x03, 0x18, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x07, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x07, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x07, 0x00, 0x07, 0x2f, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x18, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x06, 0x2a, 0x09, 0x30, 0x00, 0x2a, 0x09, 0x07, 0x06, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x30, 0x2f, 0x2a, 0x14, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x30, 0x03, 0x2a, 0x14, 0x07, 0x2f, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x07, 0x06, 0x22, 0x14, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x2a, 0x09, 0x07, 0x06, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x22, 0x11, 0x00, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x04, 0x06, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x04, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x01, 0x09, 0x04, 0x06, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x04, 0x00, 0x18, 0x1a, 0x04, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x2a, 0x11, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x01, 0x1a,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x06, 0x18, 0x1a, 0x00, 0x06, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x22, 0x11, 0x2a, 0x14, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x18, 0x1a, 0x04, 0x06, 0x18, 0x1a, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
};
static const uint8_t mode7_graphi[1920] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92,
        0x1a, 0x92,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x07, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x67, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x03, 0x58, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x52, 0x76, 0x5d, 0x76, 0x5d, 0x07, 0x52, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x76, 0x7d, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x76, 0x84, 0x07, 0x49, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x64, 0x58, 0x64, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x2a, 0x09, 0x07, 0x52, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x58, 0x00, 0x00, 0x57, 0x00, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x04, 0x06, 0x38, 0x67, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x62, 0x8a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x58, 0x57, 0x38, 0x67, 0x38, 0x67, 0x58, 0x57, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x58, 0x57, 0x38, 0x67, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x57, 0x00, 0x52, 0x38, 0x5d, 0x58, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x38, 0x5d, 0x04, 0x00, 0x04, 0x00, 0x38, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x57, 0x00, 0x57, 0x00, 0x52, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x06, 0x00, 0x06, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x47, 0x4f, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99,
        0x00, 0x99,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x92, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x00, 0x99, 0x00, 0x99, 0x00, 0x99, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
        0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
        0x1a, 0x1a,
};
static const uint8_t mode7_sepgraph[1920] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x2a, 0x1a, 0x2a, 0x14, 0x2a, 0x1a, 0x07, 0x00, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x04, 0x06, 0x07, 0x03, 0x07, 0x03, 0x18, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x07, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x07, 0x00, 0x07, 0x00, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x07, 0x00, 0x07, 0x2f, 0x07, 0x03, 0x22, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x18, 0x1a, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x06, 0x2a, 0x09, 0x30, 0x00, 0x2a, 0x09, 0x07, 0x06, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x30, 0x2f, 0x2a, 0x14, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x30, 0x03, 0x2a, 0x14, 0x07, 0x2f, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x07, 0x06, 0x22, 0x14, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x11, 0x07, 0x03, 0x07, 0x03, 0x18, 0x11, 0x2a, 0x09, 0x07, 0x06, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x22, 0x11, 0x07, 0x03, 0x07, 0x00, 0x22, 0x11, 0x00, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x22, 0x11, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x04, 0x06, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x04, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x01, 0x09, 0x04, 0x06, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x04, 0x06, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x18, 0x1a, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x04, 0x00, 0x07, 0x00, 0x18, 0x1a, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x04, 0x00, 0x18, 0x1a, 0x04, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x2a, 0x11, 0x00, 0x03, 0x00, 0x06, 0x01, 0x09, 0x01, 0x1a,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x06, 0x18, 0x1a, 0x00, 0x06, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x22, 0x11, 0x2a, 0x14, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x18, 0x1a, 0x04, 0x06, 0x18, 0x1a, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1a, 0x9a, 0x1a, 0x9a,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
};
static const uint8_t mode7_sepgraphi[1920] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x07, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x38, 0x67, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x03, 0x58, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x52, 0x76, 0x5d, 0x76, 0x5d, 0x07, 0x52, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x76, 0x7d, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x76, 0x84, 0x07, 0x49, 0x07, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x64, 0x58, 0x64, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x57, 0x07, 0x03, 0x07, 0x57, 0x2a, 0x09, 0x07, 0x52, 0x07, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x58, 0x57, 0x07, 0x00, 0x58, 0x00, 0x00, 0x57, 0x00, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x58, 0x57, 0x04, 0x06, 0x38, 0x67, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x2a, 0x14, 0x2a, 0x14, 0x62, 0x8a, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x58, 0x57, 0x38, 0x67, 0x38, 0x67, 0x58, 0x57, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x03, 0x58, 0x57, 0x38, 0x67, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x57, 0x00, 0x52, 0x38, 0x5d, 0x58, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x38, 0x5d, 0x04, 0x00, 0x04, 0x00, 0x38, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x57, 0x00, 0x57, 0x00, 0x52, 0x01, 0x09, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x06, 0x00, 0x06, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x47, 0x4f, 0x01, 0x09, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1a, 0x9a, 0x1a, 0x9a,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x00, 0xa1, 0x00, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
        0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1, 0x1c, 0xa1, 0x00, 0x00, 0x1c, 0xa1, 0x1c, 0xa1,
        0x00, 0x00,
};

#endif //B_EM_DISPLAY_TABLES_H
