/*
 * B-em Pico version (C) 2021 Graham Sanderson
 */
#include "pico/types.h"

/***********************************************************************************
 * AtlantisInternational.ttf 12 px Font in U+0020 ( ) .. U+007e (~)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
const uint8_t atlantis_glyph_bitmap[] =
        {
                /*Unicode: U+0020 ( ) , Width: 4 */
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x00,  //....

/*Unicode: U+0021 (!) , Width: 1 */
                0x00,  //.
                0x80,  //%
                0x80,  //%
                0x80,  //%
                0x80,  //%
                0x80,  //%
                0x00,  //.
                0x80,  //%
                0x00,  //.

/*Unicode: U+0022 (") , Width: 3 */
                0xa0,  //%.%
                0xa0,  //%.%
                0xa0,  //%.%
                0x00,  //...
                0x00,  //...
                0x00,  //...
                0x00,  //...
                0x00,  //...
                0x00,  //...

/*Unicode: U+0023 (#) , Width: 6 */
                0x28,  //..%.%.
                0x28,  //..%.%.
                0xfc,  //%%%%%%
                0x50,  //.%.%..
                0x50,  //.%.%..
                0xfc,  //%%%%%%
                0x50,  //.%.%..
                0x50,  //.%.%..
                0x00,  //......

/*Unicode: U+0024 ($) , Width: 5 */
                0x20,  //..%..
                0x70,  //.%%%.
                0xa8,  //%.%.%
                0xa0,  //%.%..
                0x70,  //.%%%.
                0x28,  //..%.%
                0xa8,  //%.%.%
                0x70,  //.%%%.
                0x20,  //..%..

/*Unicode: U+0025 (%) , Width: 8 */
                0x00,  //........
                0xe4,  //%%%..%..
                0xa8,  //%.%.%...
                0xe8,  //%%%.%...
                0x17,  //...%.%%%
                0x15,  //...%.%.%
                0x27,  //..%..%%%
                0x20,  //..%.....
                0x00,  //........

/*Unicode: U+0026 (&) , Width: 7 */
                0x30,  //..%%...
                0x48,  //.%..%..
                0x48,  //.%..%..
                0x30,  //..%%...
                0x52,  //.%.%..%
                0x8c,  //%...%%.
                0x8c,  //%...%%.
                0x72,  //.%%%..%
                0x00,  //.......

/*Unicode: U+0027 (') , Width: 1 */
                0x00,  //.
                0x80,  //%
                0x80,  //%
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x00,  //.

/*Unicode: U+0028 (() , Width: 3 */
                0x00,  //...
                0x20,  //..%
                0x40,  //.%.
                0x80,  //%..
                0x80,  //%..
                0x80,  //%..
                0x80,  //%..
                0x40,  //.%.
                0x20,  //..%

/*Unicode: U+0029 ()) , Width: 3 */
                0x00,  //...
                0x80,  //%..
                0x40,  //.%.
                0x20,  //..%
                0x20,  //..%
                0x20,  //..%
                0x20,  //..%
                0x40,  //.%.
                0x80,  //%..

/*Unicode: U+002a (*) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x20,  //..%..
                0xa8,  //%.%.%
                0x70,  //.%%%.
                0xa8,  //%.%.%
                0x20,  //..%..
                0x00,  //.....
                0x00,  //.....

/*Unicode: U+002b (+) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x20,  //..%..
                0x20,  //..%..
                0xf8,  //%%%%%
                0x20,  //..%..
                0x20,  //..%..
                0x00,  //.....
                0x00,  //.....

/*Unicode: U+002c (,) , Width: 2 */
                0x00,  //..
                0x00,  //..
                0x00,  //..
                0x00,  //..
                0x00,  //..
                0x00,  //..
                0x40,  //.%
                0x40,  //.%
                0x80,  //%.

/*Unicode: U+002d (-) , Width: 3 */
                0x00,  //...
                0x00,  //...
                0x00,  //...
                0x00,  //...
                0x00,  //...
                0xe0,  //%%%
                0x00,  //...
                0x00,  //...
                0x00,  //...

/*Unicode: U+002e (.) , Width: 1 */
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x80,  //%
                0x80,  //%
                0x00,  //.

/*Unicode: U+002f (/) , Width: 3 */
                0x00,  //...
                0x20,  //..%
                0x20,  //..%
                0x40,  //.%.
                0x40,  //.%.
                0x40,  //.%.
                0x80,  //%..
                0x80,  //%..
                0x00,  //...

/*Unicode: U+0030 (0) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0031 (1) , Width: 5 */
                0x00,  //.....
                0x20,  //..%..
                0x60,  //.%%..
                0x20,  //..%..
                0x20,  //..%..
                0x20,  //..%..
                0x20,  //..%..
                0xf8,  //%%%%%
                0x00,  //.....

/*Unicode: U+0032 (2) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x08,  //....%
                0x10,  //...%.
                0x20,  //..%..
                0x40,  //.%...
                0xf8,  //%%%%%
                0x00,  //.....

/*Unicode: U+0033 (3) , Width: 5 */
                0x00,  //.....
                0xf0,  //%%%%.
                0x08,  //....%
                0x08,  //....%
                0x30,  //..%%.
                0x08,  //....%
                0x08,  //....%
                0xf0,  //%%%%.
                0x00,  //.....

/*Unicode: U+0034 (4) , Width: 5 */
                0x00,  //.....
                0x10,  //...%.
                0x30,  //..%%.
                0x50,  //.%.%.
                0x90,  //%..%.
                0xf8,  //%%%%%
                0x10,  //...%.
                0x10,  //...%.
                0x00,  //.....

/*Unicode: U+0035 (5) , Width: 5 */
                0x00,  //.....
                0xf8,  //%%%%%
                0x80,  //%....
                0x80,  //%....
                0xf0,  //%%%%.
                0x08,  //....%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0036 (6) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x80,  //%....
                0xf0,  //%%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0037 (7) , Width: 5 */
                0x00,  //.....
                0xf8,  //%%%%%
                0x08,  //....%
                0x10,  //...%.
                0x20,  //..%..
                0x20,  //..%..
                0x40,  //.%...
                0x40,  //.%...
                0x00,  //.....

/*Unicode: U+0038 (8) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0039 (9) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x78,  //.%%%%
                0x08,  //....%
                0x08,  //....%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+003a (:) , Width: 1 */
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x80,  //%
                0x00,  //.
                0x00,  //.
                0x00,  //.
                0x80,  //%
                0x00,  //.

/*Unicode: U+003b (;) , Width: 2 */
                0x00,  //..
                0x00,  //..
                0x00,  //..
                0x40,  //.%
                0x00,  //..
                0x00,  //..
                0x40,  //.%
                0x40,  //.%
                0x80,  //%.

/*Unicode: U+003c (<) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x18,  //...%%
                0x60,  //.%%..
                0x80,  //%....
                0x60,  //.%%..
                0x18,  //...%%
                0x00,  //.....

/*Unicode: U+003d (=) , Width: 4 */
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0xf0,  //%%%%
                0x00,  //....
                0xf0,  //%%%%
                0x00,  //....
                0x00,  //....

/*Unicode: U+003e (>) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0xc0,  //%%...
                0x30,  //..%%.
                0x08,  //....%
                0x30,  //..%%.
                0xc0,  //%%...
                0x00,  //.....

/*Unicode: U+003f (?) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x08,  //....%
                0x10,  //...%.
                0x20,  //..%..
                0x00,  //.....
                0x20,  //..%..
                0x00,  //.....

/*Unicode: U+0040 (@) , Width: 8 */
                0x00,  //........
                0x3c,  //..%%%%..
                0x42,  //.%....%.
                0x9d,  //%..%%%.%
                0xa5,  //%.%..%.%
                0xa5,  //%.%..%.%
                0x9e,  //%..%%%%.
                0x41,  //.%.....%
                0x3e,  //..%%%%%.

/*Unicode: U+0041 (A) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0xf8,  //%%%%%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x00,  //.....

/*Unicode: U+0042 (B) , Width: 5 */
                0x00,  //.....
                0xf0,  //%%%%.
                0x88,  //%...%
                0x88,  //%...%
                0xf0,  //%%%%.
                0x88,  //%...%
                0x88,  //%...%
                0xf0,  //%%%%.
                0x00,  //.....

/*Unicode: U+0043 (C) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x80,  //%....
                0x80,  //%....
                0x80,  //%....
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0044 (D) , Width: 5 */
                0x00,  //.....
                0xf0,  //%%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0xf0,  //%%%%.
                0x00,  //.....

/*Unicode: U+0045 (E) , Width: 6 */
                0x00,  //......
                0xf8,  //%%%%%.
                0x80,  //%.....
                0x80,  //%.....
                0xf0,  //%%%%..
                0x80,  //%.....
                0x80,  //%.....
                0xf8,  //%%%%%.
                0x00,  //......

/*Unicode: U+0046 (F) , Width: 6 */
                0x00,  //......
                0xf8,  //%%%%%.
                0x80,  //%.....
                0x80,  //%.....
                0xf0,  //%%%%..
                0x80,  //%.....
                0x80,  //%.....
                0x80,  //%.....
                0x00,  //......

/*Unicode: U+0047 (G) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x80,  //%....
                0xb8,  //%.%%%
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0048 (H) , Width: 5 */
                0x00,  //.....
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0xf8,  //%%%%%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x00,  //.....

/*Unicode: U+0049 (I) , Width: 3 */
                0x00,  //...
                0xe0,  //%%%
                0x40,  //.%.
                0x40,  //.%.
                0x40,  //.%.
                0x40,  //.%.
                0x40,  //.%.
                0xe0,  //%%%
                0x00,  //...

/*Unicode: U+004a (J) , Width: 5 */
                0x00,  //.....
                0x08,  //....%
                0x08,  //....%
                0x08,  //....%
                0x08,  //....%
                0x08,  //....%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+004b (K) , Width: 5 */
                0x00,  //.....
                0x88,  //%...%
                0x90,  //%..%.
                0xa0,  //%.%..
                0xc0,  //%%...
                0xa0,  //%.%..
                0x90,  //%..%.
                0x88,  //%...%
                0x00,  //.....

/*Unicode: U+004c (L) , Width: 6 */
                0x00,  //......
                0x80,  //%.....
                0x80,  //%.....
                0x80,  //%.....
                0x80,  //%.....
                0x80,  //%.....
                0x80,  //%.....
                0xf8,  //%%%%%.
                0x00,  //......

/*Unicode: U+004d (M) , Width: 7 */
                0x00,  //.......
                0x82,  //%.....%
                0xc6,  //%%...%%
                0xaa,  //%.%.%.%
                0x92,  //%..%..%
                0x82,  //%.....%
                0x82,  //%.....%
                0x82,  //%.....%
                0x00,  //.......

/*Unicode: U+004e (N) , Width: 6 */
                0x00,  //......
                0x84,  //%....%
                0xc4,  //%%...%
                0xa4,  //%.%..%
                0x94,  //%..%.%
                0x8c,  //%...%%
                0x84,  //%....%
                0x84,  //%....%
                0x00,  //......

/*Unicode: U+004f (O) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0050 (P) , Width: 5 */
                0x00,  //.....
                0xf0,  //%%%%.
                0x88,  //%...%
                0x88,  //%...%
                0xf0,  //%%%%.
                0x80,  //%....
                0x80,  //%....
                0x80,  //%....
                0x00,  //.....

/*Unicode: U+0051 (Q) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x08,  //....%

/*Unicode: U+0052 (R) , Width: 5 */
                0x00,  //.....
                0xf0,  //%%%%.
                0x88,  //%...%
                0x88,  //%...%
                0xf0,  //%%%%.
                0xa0,  //%.%..
                0x90,  //%..%.
                0x88,  //%...%
                0x00,  //.....

/*Unicode: U+0053 (S) , Width: 5 */
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x80,  //%....
                0x70,  //.%%%.
                0x08,  //....%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0054 (T) , Width: 5 */
                0x00,  //.....
                0xf8,  //%%%%%
                0x20,  //..%..
                0x20,  //..%..
                0x20,  //..%..
                0x20,  //..%..
                0x20,  //..%..
                0x20,  //..%..
                0x00,  //.....

/*Unicode: U+0055 (U) , Width: 5 */
                0x00,  //.....
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0056 (V) , Width: 7 */
                0x00,  //.......
                0x82,  //%.....%
                0x44,  //.%...%.
                0x44,  //.%...%.
                0x28,  //..%.%..
                0x28,  //..%.%..
                0x10,  //...%...
                0x10,  //...%...
                0x00,  //.......

/*Unicode: U+0057 (W) , Width: 7 */
                0x00,  //.......
                0x82,  //%.....%
                0x82,  //%.....%
                0x82,  //%.....%
                0x92,  //%..%..%
                0xaa,  //%.%.%.%
                0xc6,  //%%...%%
                0x82,  //%.....%
                0x00,  //.......

/*Unicode: U+0058 (X) , Width: 5 */
                0x00,  //.....
                0x88,  //%...%
                0x88,  //%...%
                0x50,  //.%.%.
                0x20,  //..%..
                0x50,  //.%.%.
                0x88,  //%...%
                0x88,  //%...%
                0x00,  //.....

/*Unicode: U+0059 (Y) , Width: 5 */
                0x00,  //.....
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x50,  //.%.%.
                0x20,  //..%..
                0x20,  //..%..
                0x20,  //..%..
                0x00,  //.....

/*Unicode: U+005a (Z) , Width: 5 */
                0x00,  //.....
                0xf8,  //%%%%%
                0x08,  //....%
                0x10,  //...%.
                0x20,  //..%..
                0x40,  //.%...
                0x80,  //%....
                0xf8,  //%%%%%
                0x00,  //.....

/*Unicode: U+005b ([) , Width: 2 */
                0x00,  //..
                0xc0,  //%%
                0x80,  //%.
                0x80,  //%.
                0x80,  //%.
                0x80,  //%.
                0x80,  //%.
                0x80,  //%.
                0xc0,  //%%

/*Unicode: U+005c (\) , Width: 3 */
                0x00,  //...
                0x80,  //%..
                0x80,  //%..
                0x40,  //.%.
                0x40,  //.%.
                0x40,  //.%.
                0x20,  //..%
                0x20,  //..%
                0x00,  //...

/*Unicode: U+005d (]) , Width: 2 */
                0x00,  //..
                0xc0,  //%%
                0x40,  //.%
                0x40,  //.%
                0x40,  //.%
                0x40,  //.%
                0x40,  //.%
                0x40,  //.%
                0xc0,  //%%

/*Unicode: U+005e (^) , Width: 5 */
                0x00,  //.....
                0x20,  //..%..
                0x50,  //.%.%.
                0x88,  //%...%
                0x88,  //%...%
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....

/*Unicode: U+005f (_) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0xf8,  //%%%%%

/*Unicode: U+0060 (`) , Width: 2 */
                0x00,  //..
                0x80,  //%.
                0x40,  //.%
                0x00,  //..
                0x00,  //..
                0x00,  //..
                0x00,  //..
                0x00,  //..
                0x00,  //..

/*Unicode: U+0061 (a) , Width: 6 */
                0x00,  //......
                0x00,  //......
                0x00,  //......
                0x70,  //.%%%..
                0x08,  //....%.
                0x78,  //.%%%%.
                0x88,  //%...%.
                0x74,  //.%%%.%
                0x00,  //......

/*Unicode: U+0062 (b) , Width: 5 */
                0x00,  //.....
                0x80,  //%....
                0x80,  //%....
                0xf0,  //%%%%.
                0x88,  //%...%
                0x88,  //%...%
                0xc8,  //%%..%
                0xb0,  //%.%%.
                0x00,  //.....

/*Unicode: U+0063 (c) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x80,  //%....
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0064 (d) , Width: 5 */
                0x00,  //.....
                0x08,  //....%
                0x08,  //....%
                0x78,  //.%%%%
                0x88,  //%...%
                0x88,  //%...%
                0x98,  //%..%%
                0x68,  //.%%.%
                0x00,  //.....

/*Unicode: U+0065 (e) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0xf8,  //%%%%%
                0x80,  //%....
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0066 (f) , Width: 5 */
                0x00,  //.....
                0x30,  //..%%.
                0x40,  //.%...
                0xe0,  //%%%..
                0x40,  //.%...
                0x40,  //.%...
                0x40,  //.%...
                0x40,  //.%...
                0x00,  //.....

/*Unicode: U+0067 (g) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x78,  //.%%%%
                0x08,  //....%
                0x70,  //.%%%.

/*Unicode: U+0068 (h) , Width: 5 */
                0x00,  //.....
                0x80,  //%....
                0x80,  //%....
                0xb0,  //%.%%.
                0xc8,  //%%..%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x00,  //.....

/*Unicode: U+0069 (i) , Width: 3 */
                0x00,  //...
                0x40,  //.%.
                0x00,  //...
                0xc0,  //%%.
                0x40,  //.%.
                0x40,  //.%.
                0x40,  //.%.
                0xe0,  //%%%
                0x00,  //...

/*Unicode: U+006a (j) , Width: 3 */
                0x00,  //...
                0x20,  //..%
                0x00,  //...
                0x20,  //..%
                0x20,  //..%
                0x20,  //..%
                0x20,  //..%
                0x20,  //..%
                0xc0,  //%%.

/*Unicode: U+006b (k) , Width: 4 */
                0x00,  //....
                0x80,  //%...
                0x80,  //%...
                0x90,  //%..%
                0xa0,  //%.%.
                0xc0,  //%%..
                0xa0,  //%.%.
                0x90,  //%..%
                0x00,  //....

/*Unicode: U+006c (l) , Width: 2 */
                0x00,  //..
                0xc0,  //%%
                0x40,  //.%
                0x40,  //.%
                0x40,  //.%
                0x40,  //.%
                0x40,  //.%
                0x40,  //.%
                0x00,  //..

/*Unicode: U+006d (m) , Width: 7 */
                0x00,  //.......
                0x00,  //.......
                0x00,  //.......
                0xec,  //%%%.%%.
                0x92,  //%..%..%
                0x92,  //%..%..%
                0x92,  //%..%..%
                0x92,  //%..%..%
                0x00,  //.......

/*Unicode: U+006e (n) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0xb0,  //%.%%.
                0xc8,  //%%..%
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x00,  //.....

/*Unicode: U+006f (o) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x70,  //.%%%.
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x70,  //.%%%.
                0x00,  //.....

/*Unicode: U+0070 (p) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0xf0,  //%%%%.
                0x88,  //%...%
                0x88,  //%...%
                0xf0,  //%%%%.
                0x80,  //%....
                0x80,  //%....

/*Unicode: U+0071 (q) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x78,  //.%%%%
                0x88,  //%...%
                0x88,  //%...%
                0x78,  //.%%%%
                0x08,  //....%
                0x08,  //....%

/*Unicode: U+0072 (r) , Width: 4 */
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0xb0,  //%.%%
                0xc0,  //%%..
                0x80,  //%...
                0x80,  //%...
                0x80,  //%...
                0x00,  //....

/*Unicode: U+0073 (s) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x78,  //.%%%%
                0x80,  //%....
                0x70,  //.%%%.
                0x08,  //....%
                0xf0,  //%%%%.
                0x00,  //.....

/*Unicode: U+0074 (t) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x20,  //..%..
                0xf8,  //%%%%%
                0x20,  //..%..
                0x20,  //..%..
                0x20,  //..%..
                0x10,  //...%.
                0x00,  //.....

/*Unicode: U+0075 (u) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x98,  //%..%%
                0x68,  //.%%.%
                0x00,  //.....

/*Unicode: U+0076 (v) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x50,  //.%.%.
                0x20,  //..%..
                0x00,  //.....

/*Unicode: U+0077 (w) , Width: 7 */
                0x00,  //.......
                0x00,  //.......
                0x00,  //.......
                0x92,  //%..%..%
                0x92,  //%..%..%
                0x92,  //%..%..%
                0x92,  //%..%..%
                0x6c,  //.%%.%%.
                0x00,  //.......

/*Unicode: U+0078 (x) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x88,  //%...%
                0x50,  //.%.%.
                0x20,  //..%..
                0x50,  //.%.%.
                0x88,  //%...%
                0x00,  //.....

/*Unicode: U+0079 (y) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0x88,  //%...%
                0x88,  //%...%
                0x88,  //%...%
                0x78,  //.%%%%
                0x08,  //....%
                0x70,  //.%%%.

/*Unicode: U+007a (z) , Width: 5 */
                0x00,  //.....
                0x00,  //.....
                0x00,  //.....
                0xf8,  //%%%%%
                0x10,  //...%.
                0x20,  //..%..
                0x40,  //.%...
                0xf8,  //%%%%%
                0x00,  //.....

/*Unicode: U+007b ({) , Width: 3 */
                0x00,  //...
                0x00,  //...
                0x20,  //..%
                0x40,  //.%.
                0x40,  //.%.
                0x80,  //%..
                0x40,  //.%.
                0x40,  //.%.
                0x20,  //..%

/*Unicode: U+007c (|) , Width: 1 */
                0x00,  //.
                0x80,  //%
                0x80,  //%
                0x80,  //%
                0x80,  //%
                0x80,  //%
                0x80,  //%
                0x80,  //%
                0x80,  //%

/*Unicode: U+007d (}) , Width: 3 */
                0x00,  //...
                0x00,  //...
                0x80,  //%..
                0x40,  //.%.
                0x40,  //.%.
                0x20,  //..%
                0x40,  //.%.
                0x40,  //.%.
                0x80,  //%..

/*Unicode: U+007e (~) , Width: 4 */
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x50,  //.%.%
                0xa0,  //%.%.
                0x00,  //....
                0x00,  //....
                0x00,  //....
                0x00,  //....

        };

const uint8_t atlantis_glyph_widths[] =
        {
                2, //4,    /*Unicode: U+0020 ( )*/
                1,    /*Unicode: U+0021 (!)*/
                3,    /*Unicode: U+0022 (")*/
                6,    /*Unicode: U+0023 (#)*/
                5,    /*Unicode: U+0024 ($)*/
                8,    /*Unicode: U+0025 (%)*/
                7,    /*Unicode: U+0026 (&)*/
                1,    /*Unicode: U+0027 (')*/
                3,    /*Unicode: U+0028 (()*/
                3,        /*Unicode: U+0029 ())*/
                5,        /*Unicode: U+002a (*)*/
                5,        /*Unicode: U+002b (+)*/
                2,        /*Unicode: U+002c (,)*/
                3,        /*Unicode: U+002d (-)*/
                1,        /*Unicode: U+002e (.)*/
                3,        /*Unicode: U+002f (/)*/
                5,        /*Unicode: U+0030 (0)*/
                5,        /*Unicode: U+0031 (1)*/
                5,        /*Unicode: U+0032 (2)*/
                5,        /*Unicode: U+0033 (3)*/
                5,        /*Unicode: U+0034 (4)*/
                5,        /*Unicode: U+0035 (5)*/
                5,        /*Unicode: U+0036 (6)*/
                5,        /*Unicode: U+0037 (7)*/
                5,        /*Unicode: U+0038 (8)*/
                5,        /*Unicode: U+0039 (9)*/
                1,        /*Unicode: U+003a (:)*/
                2,        /*Unicode: U+003b (;)*/
                5,        /*Unicode: U+003c (<)*/
                4,        /*Unicode: U+003d (=)*/
                5,        /*Unicode: U+003e (>)*/
                5,        /*Unicode: U+003f (?)*/
                8,        /*Unicode: U+0040 (@)*/
                5,        /*Unicode: U+0041 (A)*/
                5,        /*Unicode: U+0042 (B)*/
                5,        /*Unicode: U+0043 (C)*/
                5,        /*Unicode: U+0044 (D)*/
                6,        /*Unicode: U+0045 (E)*/
                5, //6       /*Unicode: U+0046 (F)*/
                5,        /*Unicode: U+0047 (G)*/
                5,        /*Unicode: U+0048 (H)*/
                3,        /*Unicode: U+0049 (I)*/
                5,        /*Unicode: U+004a (J)*/
                5,        /*Unicode: U+004b (K)*/
                6,        /*Unicode: U+004c (L)*/
                7,        /*Unicode: U+004d (M)*/
                6,        /*Unicode: U+004e (N)*/
                5,        /*Unicode: U+004f (O)*/
                5,        /*Unicode: U+0050 (P)*/
                5,        /*Unicode: U+0051 (Q)*/
                5,        /*Unicode: U+0052 (R)*/
                5,        /*Unicode: U+0053 (S)*/
                4, //5,        /*Unicode: U+0054 (T)*/
                5,        /*Unicode: U+0055 (U)*/
                7,        /*Unicode: U+0056 (V)*/
                7,        /*Unicode: U+0057 (W)*/
                5,        /*Unicode: U+0058 (X)*/
                5,        /*Unicode: U+0059 (Y)*/
                5,        /*Unicode: U+005a (Z)*/
                2,        /*Unicode: U+005b ([)*/
                3,        /*Unicode: U+005c (\)*/
                2,        /*Unicode: U+005d (])*/
                5,        /*Unicode: U+005e (^)*/
                5,        /*Unicode: U+005f (_)*/
                2,        /*Unicode: U+0060 (`)*/
                5, //6,        /*Unicode: U+0061 (a)*/
                5,        /*Unicode: U+0062 (b)*/
                5,        /*Unicode: U+0063 (c)*/
                5,        /*Unicode: U+0064 (d)*/
                5,        /*Unicode: U+0065 (e)*/
                4, //5,        /*Unicode: U+0066 (f)*/
                5,        /*Unicode: U+0067 (g)*/
                5,        /*Unicode: U+0068 (h)*/
                3,        /*Unicode: U+0069 (i)*/
                3,        /*Unicode: U+006a (j)*/
                4,        /*Unicode: U+006b (k)*/
                2,        /*Unicode: U+006c (l)*/
                7,        /*Unicode: U+006d (m)*/
                5,        /*Unicode: U+006e (n)*/
                5,        /*Unicode: U+006f (o)*/
                5,        /*Unicode: U+0070 (p)*/
                5,        /*Unicode: U+0071 (q)*/
                4,        /*Unicode: U+0072 (r)*/
                5,        /*Unicode: U+0073 (s)*/
                5,        /*Unicode: U+0074 (t)*/
                5,        /*Unicode: U+0075 (u)*/
                5,        /*Unicode: U+0076 (v)*/
                7,        /*Unicode: U+0077 (w)*/
                5,        /*Unicode: U+0078 (x)*/
                5,        /*Unicode: U+0079 (y)*/
                5,        /*Unicode: U+007a (z)*/
                3,        /*Unicode: U+007b ({)*/
                1,        /*Unicode: U+007c (|)*/
                3,        /*Unicode: U+007d (})*/
                4,        /*Unicode: U+007e (~)*/
        };


// note the above have 2 pixels off the top and 1 off the bottom
