#ifndef _hatdefs
	#define _hatdefs
	
	#define CLOCK 8000000
	#define PORTSERIAL PORTC
	#define DDRSERIAL DDRC
	#define CK_SH0 PC0
	#define DATA0 PC1
	#define CK_BUF0 PC2
	#define OE0 PC3
	#define CK_SH1 PC4
	#define DATA1 PC5
	#define CK_BUF1 PC6
	#define OE1 PC7
	#define OUTPUTBITS _BV(CK_SH0)|_BV(DATA0)|_BV(CK_BUF0)|_BV(OE0)|_BV(CK_SH1)|_BV(DATA1)|_BV(CK_BUF1)|_BV(OE1)

	#define ANALOG_INPUT PA4

	#define PORTINPUT PIND
	#define SW1 PD0
	#define SW2 PD1
	#define SW3 PD2
	#define INPUTBITS (_BV(SW1)|_BV(SW2) |_BV(SW3))

	#define BYTE uint8_t
	#define LONG uint32_t

	#define NROWS 10
	#define NCOLS 21
	#define NCOLSBYTES 3
	#define RBIT 4
	#define LEAP 4
	#define FPS 100
	
	
	#define SW1_DOWN 1
	#define SW1_UP   2
	#define SW2_DOWN 4
	#define SW2_UP   8
	#define SW3_DOWN 16
	#define SW3_UP   32
	#define SW1_REPEAT 64
	#define SW2_REPEAT 128

	typedef BYTE* pbyte_t;
	typedef LONG* plong_t;

	
	volatile uint8_t count;
	volatile uint8_t framecount;

	BYTE string_ptr;
	
	// --------------------------------------------------
	// Digital filter for analog input
	// --------------------------------------------------

	volatile BYTE analoglevel;
	volatile int32_t peakenv;
	volatile int32_t f1out;
	volatile int32_t f2out;
	volatile int32_t beatpeakenv;

	// samplerate = 9600 samples/s
	#define KBEATFILTER 64 // samplerate /(2 x pi x filter freq) 

	BYTE analogdivider;
	#define ANALOGDIVIDEROFFSET 15
	#define ANALOGDIVIDERRANGE 5

	#define INVADERINDEX 135
	#define SMALLINDEX 125
	#define FIRSTINDEX 32
	
	BYTE mode;
	BYTE submode;
	BYTE subsubmode;
	
	BYTE analogontext;
	
	BYTE string_ptr;
	BYTE string_index;
	BYTE string_cycle;
	
	BYTE editstringno;
	BYTE editchar;
	BYTE editpos;
	
	BYTE out1bitck0;
	BYTE out0bitck0;
	BYTE outbitck1;
	BYTE outframeck1;
	
	BYTE displays;


	#define DISPLAYSTRINGLEN 64
	#define NSTRINGS 6
	
	#define NMODES 12
	#define NCYCLEMODES 11
	#define NORDINARYMODES 10
	#define TEXT0MODE 0
	#define TEXT1MODE 1
	#define TEXT2MODE 2
	#define TEXT3MODE 3
	#define TEXT4MODE 4
	#define TEXT5MODE 5
	#define CYCLICTEXTMODE 6
	#define ANALOGBOX 7
	#define PONG 8
	#define INVADERS 9
	#define RANDOM 10
	#define MENU 11
	
	#define MAXCHARWIDTH 5
	
	#define MAXCYCLICCHAR 124
	#define DELCHAR 123
	#define ENTERCHAR 124
	
	#define REPEATDELAY 50
	#define REPEATRATE 14
	
	char display_string[2][DISPLAYSTRINGLEN];
	char editstring[DISPLAYSTRINGLEN];
	
#endif

