#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/delay.h>
#include <avr/sleep.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <string.h>
#include <math.h>

#include "hatdefs.h"
#include "draw.h"
#include "menu.h"
#include "stdio.h"



prog_char menuanalogstr[]="An:";
prog_char menudisplaysstr[]="Di:";
prog_char menusensitivitystr[]="Se:";
prog_char menuexitstr[]="Exit";
prog_char menueditstr[]="Ed:";

PGM_P menustrs[NMENUS] PROGMEM = { menuanalogstr, menudisplaysstr, menusensitivitystr, menuexitstr, menueditstr };

	
void initmenu(void)
{
	subsubmode=0;
	editchar=65;
	editpos=0;
	editstring[0]=0;
	clearbuf();
}

void printeditstring(void)
{
	if (editpos>=2)
		print(editstring[editpos-2],0,2);
	if (editpos>=1)
		print(editstring[editpos-1],MAXCHARWIDTH+1,2);
	print(editchar,2*(MAXCHARWIDTH+1),2);
	drawhline(2*(MAXCHARWIDTH+1),3*MAXCHARWIDTH+1,0);
}

void printmenu(void)
{
	PGM_P p;
	int i;
	memcpy_P(&p, &menustrs[submode], sizeof(PGM_P));
	memcpy_P(&(display_string[0][0]),p,5);
	switch (submode) {
		case manalog:
			i=printstring(0,2,(subsubmode==0));
			if (analogontext)
				snprintf(&(display_string[0][0]),DISPLAYSTRINGLEN,"y");
			else
				snprintf(&(display_string[0][0]),DISPLAYSTRINGLEN,"n");
			printstring(i,2,(subsubmode!=0));
		break;
		case mdisplays:
			i=printstring(0,2,(subsubmode==0));
			switch (displays){
				case 1:
				snprintf(&(display_string[0][0]),DISPLAYSTRINGLEN,"f");
				break;
				case 2:
				snprintf(&(display_string[0][0]),DISPLAYSTRINGLEN,"b");
				break;
				case 3:
				snprintf(&(display_string[0][0]),DISPLAYSTRINGLEN,"2");
				break;
			}
			printstring(i,2,(subsubmode!=0));
		break;
		case msensitivity:
			i=printstring(0,2,(subsubmode==0));
			snprintf(&(display_string[0][0]),DISPLAYSTRINGLEN,"%u",analogdivider-ANALOGDIVIDEROFFSET);
			printstring(i,2,(subsubmode!=0));
		break;
		case mexit:
			printstring(0,2,1);
		break;
		case medit:
			if (subsubmode<2)
			{
				i=printstring(0,2,0);
				if (subsubmode)
					snprintf(&(display_string[0][0]),DISPLAYSTRINGLEN,"y");
				else
					snprintf(&(display_string[0][0]),DISPLAYSTRINGLEN,"n");
				printstring(i,2,1);
			}
			else
				printeditstring();
		break;
	}
	next_buf=write_buf;
}



void menuscroll(BYTE switches)
{
	if (switches==SW1_DOWN)
		submode=(submode+1)%NCYCLICMENUS;
	else
		submode=(submode == 0) ? NCYCLICMENUS-1 : submode-1;
	subsubmode=0;
	clearbuf();
	printmenu();
}

int manaloginput(BYTE switches)
{
	switch (subsubmode) {
		case 0:
		switch (switches) {
		case SW1_DOWN:
		case SW2_DOWN:
			menuscroll(switches);
			break;
		case SW3_DOWN:
			subsubmode=1;
			clearbuf();
			printmenu();
			break;
		}
		break;
		case 1:
		switch (switches) {
			case SW1_DOWN:
			case SW2_DOWN:
				analogontext=1-analogontext;
				clearbuf();
				printmenu();
				break;
			case SW3_DOWN:
				return 1;
				break;
			}
		break;
		}
	return 0;
}

int mdisplaysinput(BYTE switches)
{
	switch (subsubmode) {
		case 0:
		switch (switches) {
		case SW1_DOWN:
		case SW2_DOWN:
			menuscroll(switches);
			break;
		case SW3_DOWN:
			subsubmode=1;
			clearbuf();
			printmenu();
			break;
		}
		break;
		case 1:
		switch (switches) {
			case SW1_DOWN:
				displays++;
				if (displays==4)
					displays=0;
				setupdisplays(displays&1, displays&2);
				clearbuf();
				printmenu();
				break;
			case SW2_DOWN:
				if (displays==0)
					displays=3;
				else
					displays--;
				setupdisplays(displays&1, displays&2);
				clearbuf();
				printmenu();
				break;
			case SW3_DOWN:
				return 1;
				break;
			}
		break;
		}
	return 0;
}


int msensitivityinput(BYTE switches)
{
	BYTE b;
	
	switch (subsubmode) {
		case 0:
		switch (switches) {
		case SW1_DOWN:
		case SW2_DOWN:
			menuscroll(switches);
			break;
		case SW3_DOWN:
			subsubmode=1;
			clearbuf();
			printmenu();
			break;
		}
		break;
		case 1:
		switch (switches) {
			case SW1_DOWN:
				if ((analogdivider-ANALOGDIVIDEROFFSET)<ANALOGDIVIDERRANGE)
					analogdivider++;
				clearbuf();
				printmenu();
				break;
			case SW2_DOWN:
				if ((analogdivider-ANALOGDIVIDEROFFSET)>1)
					analogdivider--;
				clearbuf();
				printmenu();
				break;
			case SW3_DOWN:
				b=analogdivider+48-ANALOGDIVIDEROFFSET;
				eeprom_write_block(&b,(void*)(0),1);
				return 1;
				break;
			}
		break;
		}
	return 0;
}

int mexitinput(BYTE switches)
{
	switch (switches) {
			case SW1_DOWN:
			case SW2_DOWN:
				menuscroll(switches);
			break;
			case SW3_DOWN:
				return 1;
		break;
		}
	return 0;
}

int meditlow(BYTE switches)
{
	switch (switches) {
		case SW1_DOWN:
		case SW2_DOWN:
			subsubmode=1-subsubmode;
			clearbuf();
			printmenu();
		break;
		case SW3_DOWN:
			if (subsubmode==0)
				return 1;
			else
			{
				subsubmode=2;
				clearbuf();
				printmenu();
			}
		}
	return 0;
}

int medithigh(BYTE switches)
{
	switch (switches) {
		case SW1_DOWN:
		case SW1_REPEAT:
			do {
				editchar++;
				if (editchar>MAXCYCLICCHAR)
					editchar = 32;
				} while (badchar(editchar));
				clearbuf();
				printmenu();
		break;
		case SW2_DOWN:
		case SW2_REPEAT:
			do {
				editchar--;
				if (editchar<32)
					editchar = MAXCYCLICCHAR;
			} while (badchar(editchar));
			clearbuf();
			printmenu();
		break;
	
		case SW3_DOWN:
			if (editchar==DELCHAR)
			{
				if (editpos>0)
				{
					editstring[editpos]=0;
					editpos--;
				}
			}
			else
			{
				if (editchar!=ENTERCHAR)
				{
					if (editpos<DISPLAYSTRINGLEN-2)
						{
							editstring[editpos]=editchar;
							editstring[editpos+1]=0;
							editpos++;
						}
				}
				else
				{
					if ((editpos>0)&&(editpos<DISPLAYSTRINGLEN-4))
					{
						editstring[editpos]  =32;
						editstring[editpos+1]=32;
						editstring[editpos+2]=32;
						editstring[editpos+3]=0;
					}
					eeprom_write_block(&(editstring[0]),(void*)(3+(int16_t)DISPLAYSTRINGLEN*(int16_t)editstringno),DISPLAYSTRINGLEN);
					return 1;
				}
			}
			clearbuf();
			printmenu();
		break;
	}
	return 0;
}


int menuinput(BYTE switches)
{
	switch (submode){
	case manalog:
		return manaloginput(switches);
		break;
	case mdisplays:
		return mdisplaysinput(switches);
		break;
	case msensitivity:
		return msensitivityinput(switches);
		break;
	case mexit:
		return mexitinput(switches);
	break;
	case medit:
		if (subsubmode<2)
			return meditlow(switches);
		else
			return medithigh(switches);
	break;
	}
	return 0;
}

